<?php 
if (!defined("B_PROLOG_INCLUDED") || B_PROLOG_INCLUDED !== true) die();

define("NO_KEEP_STATISTIC", true);
define("NOT_CHECK_PERMISSIONS", true);

include(GetLangFileName(dirname(__FILE__)."/", "/lang.php"));

if (isset($_GET["order_id"]) && isset($_GET["checksum"]))
{
	if (!($arOrder = CSaleOrder::GetByID(intval($_GET["merchant_order_id"]))))
	{
		echo $arOrder["ID"]."|error";
		exit;
	}

	CSalePaySystemAction::InitParamArrays($arOrder, $arOrder["ID"]);

	$site = CSalePaySystemAction::GetParamValue("MERCHANT_ID");
	$key = CSalePaySystemAction::GetParamValue("SECRET_KEY");

	$orderId = $_GET['merchant_order_id'];
	$msg = "";
	if (isset($_GET['code'])) { $msg .= "code=".$_GET['code'].";"; }
	if (isset($_GET['merchant_order_id'])) { $msg .= "merchant_order_id=".$_GET['merchant_order_id'].";"; }
	$msg .= "message=".$_GET['message'].";";
	if (isset($_GET['order_id'])) { $msg .= "order_id=".$_GET['order_id'].";"; }
	$msg .= "status=".$_GET['status'];
	$signature = hash_hmac('sha1', $msg, $key);

	$log_text = 
	"--------------------------------------------------------\n".
	"operation id		".$_GET["order_id"]."\n".
	"operation ps		".$_GET["message"]."\n".
	"order id			".$_GET["merchant_order_id"]."\n".
	"description		".base64_decode($_GET["description"])."\n".
	"status				".$_GET["status"]."\n".
	"sign				".$_GET["checksum"]."\n\n";
	
	if (CSalePaySystemAction::GetParamValue("GATELINE_LOG") != '')
	{	
		file_put_contents($_SERVER['DOCUMENT_ROOT'] . CSalePaySystemAction::GetParamValue("GATELINE_LOG"), $log_text, FILE_APPEND);
	}

	if ($_GET["checksum"] == $signature && $_GET['message'] == "Success")
	{
		if ($arOrder["PAYED"]=="N")
		{
			$arFields = array(
				"PS_STATUS" => "Y",
				"PS_STATUS_CODE" => $_GET['code'],
				"PS_STATUS_DESCRIPTION" => $_GET['status'],
				"PS_STATUS_MESSAGE" => $_GET['message'],
				"PS_SUM" => $arOrder["PRICE"],
				"PS_RESPONSE_DATE" => date(CDatabase::DateFormatToPHP(CLang::GetDateFormat("FULL", LANG))),
				"USER_ID" => $arOrder["USER_ID"],
				);
			
			if (CSaleOrder::Update($arOrder["ID"], $arFields))
			{
				file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/bitrix/modules/log.txt', "I am here2\n", FILE_APPEND);
				CSaleOrder::PayOrder($arOrder["ID"], "Y", false);
				CSaleOrder::StatusOrder($arOrder["ID"], "P");
				LocalRedirect("/payment/gateline/success.php");
			}
		}
		else
		{
			LocalRedirect("/payment/gateline/fail.php");
		}
	}
	LocalRedirect("/payment/gateline/fail.php");
} else {LocalRedirect("/payment/gateline/fail.php");}
?>